' TpiNetClient.cs
'
' This file implements a Form-derived class that is also
' a remote TPI.NET client. It demonstrates how to connect
' to a remote TLA and subscribe to events raised by TPI.NET.
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Imports Tektronix.LogicAnalyzer.TpiNet
Imports System
Imports System.Windows.Forms

Public Class Form1
    Inherits System.Windows.Forms.Form

    ' A reference to the top of the TPI.NET object hierarchy
    ' in the remote TLA application
    Dim m_system As ITlaSystem

    ' Event shims that are required to subscribe to
    ' events raised by the remote TLA application.
    Dim runStartRemoter As EventRemoter
    Dim runCompleteRemoter As EventRemoter

    ' The constructor connects to the remote TLA application and 
    ' subscribes to two of the ITlaRunControl events.
    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        Dim version As String = Nothing

        ' The assembly TlaNetInterfaces, which this project references,
        ' contains a utility class named RemoteTlaSystem. It has a
        ' Connect() static method which is used to set up a connection
        ' to a remote TLA. To connect, an application configuration file
        ' named TpiNetRemoteClient.config is used. This file contains
        ' the information needed to configure this application to
        ' communicate with a TLA running on the local host. The
        ' configuration file can be modified to connect to a TLA
        ' on a network.
        ' NOTE: For the call to Connect() to succeed, the file
        ' TpiNetRemoteClient.config must be in the same directory as
        ' the application executable.
        Try
            m_system = RemoteTlaSystem.Connect("TpiNetRemoteClient.config")
            version = m_system.SWVersion
        Catch
            ' Failed to connect.
            MessageBox.Show("Could not connect to the TLA application. Make sure the TLA application is running before starting the client application. Also make sure the configuration file is located in the executable directory.")
            m_system = Nothing
        End Try

        If m_system Is Nothing Then
            versionLabel.Text = "Could not connect to TLA application"
            runButton.Enabled = False
            runButton.Text = "Cannot run TLA"
        Else
            ' Connection was successful. Now subscribe to TPI.NET events.
            ' In order to subscribe, an intermediate shim object, whose type
            ' is known to the TLA, is needed. In TPI.NET, we call these 
            ' shims "remoters." To subscribe to a remote TPI.NET event
            ' follow these steps.
            '
            ' 1 )Create a remoter object of the appropriate type (see the 
            ' document "TPI.NET Remote Client Design Guide for details).
            ' 
            ' 2) Subscribe the remoter object to the TPI.NET event using
            ' a delegate for the remoter method named OnRemoteEvent().
            '
            ' 3) Subscribe a local class method to the RemoteEventOccurred 
            ' event of the remoter object.
            '
            ' When the subscribed TPI.NET event is raised, the TLA will
            ' make a callback to the remoter object. The remoter will,
            ' in turn, raise its RemoteEventOccurred event; and the local
            ' event handler will be called with same arguments that the
            ' TLA application passed to the remoter.
            '
            ' These steps are demonstrated in the code below, which
            ' subscribes to ITlaRunControl.RunStarted and
            ' ITlaRunControl.RunCompleted.

            ' Subscribe to ITlaRunControl.RunStarted.
            runStartRemoter = New EventRemoter()
            AddHandler m_system.RunControl.RunStarted, AddressOf runStartRemoter.OnRemoteEvent
            AddHandler runStartRemoter.RemoteEventOccurred, AddressOf Me.OnRunStarted

            ' Subscribe to ITlaRunControl.RunCompleted.
            runCompleteRemoter = New EventRemoter()
            AddHandler m_system.RunControl.RunCompleted, AddressOf runCompleteRemoter.OnRemoteEvent
            AddHandler runCompleteRemoter.RemoteEventOccurred, AddressOf Me.OnRunCompleted

            ' Local events don't need shims.
            AddHandler runButton.Click, AddressOf Me.OnRunButton
            AddHandler Me.Click, AddressOf Me.OnFormClosed

            versionLabel.Text = String.Format("TLA Software Version is {0}", version)
        End If

    End Sub

#Region " Windows Form Designer generated code "

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents versionLabel As System.Windows.Forms.Label
    Friend WithEvents runButton As System.Windows.Forms.Button
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents eventLabel As System.Windows.Forms.Label
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.versionLabel = New System.Windows.Forms.Label()
        Me.runButton = New System.Windows.Forms.Button()
        Me.Label1 = New System.Windows.Forms.Label()
        Me.eventLabel = New System.Windows.Forms.Label()
        Me.SuspendLayout()
        '
        'versionLabel
        '
        Me.versionLabel.Location = New System.Drawing.Point(16, 16)
        Me.versionLabel.Name = "versionLabel"
        Me.versionLabel.Size = New System.Drawing.Size(256, 24)
        Me.versionLabel.TabIndex = 0
        Me.versionLabel.Text = "Label1"
        '
        'runButton
        '
        Me.runButton.Location = New System.Drawing.Point(40, 56)
        Me.runButton.Name = "runButton"
        Me.runButton.Size = New System.Drawing.Size(224, 32)
        Me.runButton.TabIndex = 1
        Me.runButton.Text = "Run the TLA"
        '
        'Label1
        '
        Me.Label1.Location = New System.Drawing.Point(24, 112)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(264, 24)
        Me.Label1.TabIndex = 2
        Me.Label1.Text = "Most Recent Run Event:"
        '
        'eventLabel
        '
        Me.eventLabel.Location = New System.Drawing.Point(24, 152)
        Me.eventLabel.Name = "eventLabel"
        Me.eventLabel.Size = New System.Drawing.Size(264, 24)
        Me.eventLabel.TabIndex = 3
        Me.eventLabel.Text = "None."
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(6, 15)
        Me.ClientSize = New System.Drawing.Size(312, 216)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.eventLabel, Me.Label1, Me.runButton, Me.versionLabel})
        Me.Name = "Form1"
        Me.Text = "VB Remote TPI.NET Client"
        Me.ResumeLayout(False)

    End Sub

#End Region

    ' Event handler for the ITlaRunControl.RunStarted event.
    Private Sub OnRunStarted(ByVal sender As Object, ByVal args As EventArgs)
        eventLabel.Text = "An acquisition started."
        runButton.Enabled = False
    End Sub

    'Event handler for the ITlaRunControl.RunCompleted event.
    Private Sub OnRunCompleted(ByVal sender As Object, ByVal args As EventArgs)
        eventLabel.Text = "An acquisition completed."
        runButton.Enabled = True
    End Sub


    ' Starts a TLA acquistion when the user clicks the 
    ' "Run the TLA" button.
    Private Sub OnRunButton(ByVal sender As Object, ByVal args As EventArgs)
        If Not m_system Is Nothing Then
            m_system.RunControl.Run()
        End If
    End Sub


    ' Removes TPI.NET event subscriptions when the user exits the
    ' application. TPI.NET clients should always clean up their
    ' subscriptions before exiting.
    Private Sub OnFormClosed(ByVal sender As Object, ByVal args As EventArgs)
        RemoveHandler m_system.RunControl.RunCompleted, AddressOf runCompleteRemoter.OnRemoteEvent
        RemoveHandler m_system.RunControl.RunStarted, AddressOf runStartRemoter.OnRemoteEvent
    End Sub
End Class
